/* 
 * wv.c 
 *
 * Виводить свої аргументи в заданий файл.
 * Ілюструє порядок застосування функції writev().
 *
 */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/uio.h>
#include <unistd.h>


int main(int argc, char *argv[])
{
        struct iovec *vec;
        int i;
        char filename[] = "argfile.txt";
        int fd;
        char newline = '\n';

        argc--;
        argv++;
        if (argc == 0)
                exit(EXIT_SUCCESS);

        /* Розміщує пам'ять для масиву vec. */
        vec = malloc(2*argc*sizeof(*vec));
        if (vec == NULL) {
                fprintf(stderr, "Not enough memory\n");
                exit(EXIT_FAILURE);
        }

        /* Розміщує аргументи в масиві vec. Кожному аргументу
           відповідає 2 елементи масиву: один для самого аргументу,
           другий для символу кінця рядка. */
        for (i = 0; i < argc; i++) {
                vec[2*i].iov_base = (void *) argv[i];
                vec[2*i].iov_len = strlen(argv[i]);
                vec[2*i + 1].iov_base = &newline;
                vec[2*i + 1].iov_len = 1;
        }

        /* Відкриває файл для запису; якщо не існує - створює,
           якщо непорожній - обнуляє розмір. */
        fd = creat(filename, 00600);
        if (fd < 0) {
                perror("creat()");
                exit(EXIT_FAILURE);
        }

        /* Записує аргументи в файл. */
        if (writev(fd, vec, 2*argc) < 0) {
                perror("writev()");
                exit(EXIT_FAILURE);
        }

        exit(EXIT_SUCCESS);
}
